********************** 	Code for "Bonus to Burden"   ***************************

* Title: 
* 	"From Bonus to Burden: The Cost of Ruling From a New(s) Perspective 


* Authors: 
*	Gunnar Thesen, Christoffer Green-Pedersen, Peter B. Mortensen
********************************************************************************

* Last updated: February 17th  2024



********************************************************************************
* Load data
use "Bonus to Burden Main dataset.dta", clear
xtset new_cab_id rankedmonths
********************************************************************************


	
********************************************************************************
			****************** Descriptives  ******************
			************ For Table 1 & 2, manuscript **********
********************************************************************************

** Table 1
tabstat incumbency_bonus, by(country) stat(min mean max)
* Sig testing with ttest
ttest incumbency_bonus == 0 if country=="dk"
ttest incumbency_bonus == 0 if country=="uk"
ttest incumbency_bonus == 0 if country=="nl"
ttest incumbency_bonus == 0 if country=="no"
ttest incumbency_bonus == 0
tab country incumbency_bonus_bin, row 
* Sig testing with confidence intervals for proportions
ci proportions incumbency_bonus_bin if country=="dk"
ci proportions incumbency_bonus_bin if country=="uk"
ci proportions incumbency_bonus_bin if country=="nl"
ci proportions incumbency_bonus_bin if country=="no"
ci proportions incumbency_bonus_bin 

** Table 2
tabstat incumbency_burden, by(country) stat(min mean max)
* Sig testing with ttest
ttest incumbency_burden == 0 if country=="dk"
ttest incumbency_burden == 0 if country=="uk"
ttest incumbency_burden == 0 if country=="nl"
ttest incumbency_burden == 0 if country=="no"
ttest incumbency_burden == 0
tab country incumbency_burden_bin, row
* Sig testing with confidence intervals for proportions
ci proportions incumbency_burden_bin if country=="dk"
ci proportions incumbency_burden_bin if country=="uk"
ci proportions incumbency_burden_bin if country=="nl"
ci proportions incumbency_burden_bin if country=="no"
ci proportions incumbency_burden_bin 
********************************************************************************
********************************************************************************




********************************************************************************
			********** Main models for manuscript *************
			****** For Table B.1, appendix and Figure 1, ******
			********** Fig 2 and Fig 3, manuscript *************
********************************************************************************

************************ Main models *******************************************
** Only H2a
xtreg vi_gov lag_vi_gov  ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std  ///
    bonus_std burden_std ///
	, fe vce(cluster new_cab_id)
est store kun_H2a

** Only H2b
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std cum_burden_std ///
	, fe vce(cluster new_cab_id)
	est store kun_H2b

** Main model with H2a og H2b
xtreg vi_gov burden_std cum_burden_std ///
	lag_vi_gov months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store hovedmodell_H2a_og_H2b

** H2c 
xtreg vi_gov burden_std cum_burden_std tenureXburden ///
	lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store interaksjonsmodell_H2c

** H3
xtreg vi_gov burden_std cum_burden_std cab_parties_2Xburden cab_parties_3Xburden cab_parties_4Xburden  ///
	lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, re vce(cluster new_cab_id)
est store interaksjonsmodell_H3

** Table for main results - Reported in online appendix, Table B.1 
esttab hovedmodell_H2a_og_H2b kun_H2a kun_H2b interaksjonsmodell_H2c interaksjonsmodell_H3 ///
	using "main_models.csv", replace ///
	stats(r2_w r2_o N_g N, fmt(%9.3f %9.3f %9.0f %9.0f) labels(Within-R2 Overall-R2 Cabinets Observations)) ///
	mlabels("Model 1" "Model 2" "Model 3" "Model 4" "Model 5") ///
	label nobaselevels plain  ///
	order(burden_std cum_burden_std tenureXburden cab_parties_2Xburden cab_parties_3Xburden cab_parties_4Xburden) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties==     2.0000" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     3.0000" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     4.0000" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_total (standardized)" "Salience of political news" ///
	"incumbency_bonus (standardized)" "Incumbency bonus" ///
	"incumbency_burden (standardized)" "Incumbency burden" ///
	"cumulated_burden (standardized)" "Cumulated incumbency burden" ///
	"tenureXburden" "Incumbency burden # Tenure" ///
	"cab_parties_2Xburden" "Incumbency burden # 2-party cabinet" ///
	"cab_parties_3Xburden" "Incumbency burden # 3-party cabinet" ///
	"cab_parties_4Xburden" "Incumbency burden # 4-party cabinet" ///
	"Constant" "Intercept" ///
	"Observations" "N")

** Coefficient plot for manuscript - Figure 1 in manuscript
xtreg vi_gov burden_std cum_burden_std ///
	lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right_distance ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store hovedmodell_til_coefplot

coefplot ///
	(hovedmodell_til_coefplot), ///
	scheme(s1mono) levels(95 90) ///
	drop(_cons no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4) ///
	xline(0, lpattern(shortdash) lcolor(black)) ///
	rename(burden_std="{bf:Incumbency burden}" cum_burden_std="{bf:Cumulated burden}" lag_vi_gov="Incumbent support, t-1" ///
	months_in_office_new_cab_id="Tenure in months" cab_share="Cabinet seat share" ///
	cab_left_right_distance="Cabinet L-R distance" unemployment="Unemployment" cli="Economic activity" actor_occ_std="Salience of political news" ///
	bonus_std="Incumbency bonus") ///
	title("", size(small)) ///
	name (g1, replace) ///
	`display' `ci'
graph export Figure1.png, replace
********************************************************************************


************************ Interaction models ************************************
** H2c, Figure 2
qui: ///
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std  ///
    bonus_std burden_std cum_burden_std ///
	c.months_in_office_new_cab_id#c.burden_std ///
	, fe vce(cluster new_cab_id)
* Marginal effects plots (dydx)
margins, dydx(burden_std) at (months_in_office_new_cab=(0 (12) 96)) level(95)
marginsplot, scheme(s1mono) title("") ytitle("Marginal effect of burden on support") xtitle("Tenure in months") ///
	recast(line) yscale(range(-1 0.4)) ytick(-1(0.2)0.4) ylabel(-1(0.2)0.4) yline(0, lpattern(dash)) recastci(rline) ciopts(lpattern(solid) lcolor(gs10) lwidth(vvvthin))  ///
	legend(off) graphregion(fcolor(white) ifcolor(white)) 
graph export Figure2.png, replace
	
** H3, Figure 3
qui: ///
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	i.no_of_cab_parties#c.burden_std  ///
	, re vce(cluster new_cab_id)
* Marginal effects plots (dydx) - med burden 
eststo marH3: margins, dydx(burden_std) at (no_of_cab_parties=(1 2 3)) level(95) post
marginsplot, scheme(s1mono) title("") ytitle("Marginal effect of burden on support") xtitle("No. of cabinet parties") ///
	recast(scatter) xscale(range(0.75 3.25)) yscale(range(-1 0.4)) ytick(-1(0.2)0.4) ylabel(-1(0.2)0.4) yline(0, lpattern(dash)) ///
	legend(off) graphregion(fcolor(white) ifcolor(white)) name(g1, replace)

* NB - use coefplot to show two levels of significance, but need some manual editing of labels etc
coefplot ///
	(marH3), vertical ///
	scheme(s1mono) levels(95 90) ///
	xline(0, lpattern(shortdash) lcolor(black)) ///
	rename(1._at="1" 2._at="2" 3._at="3") ///
	title("", size(small)) ///
	name (graph_marginal_effects_H3, replace) ///
	`display' `ci'

graph export Figure3.png, replace
********************************************************************************





********************************************************************************
			***************************************************
			*** Various supplementary models for appendix *****
			***************************************************
********************************************************************************


************************ Stepwise results **************************************
******************* For Table B.2 in appendix **********************************
* Without burden variables
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
	actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store stegvis_m1
* With burden variables
xtreg vi_gov lag_vi_gov burden_std cum_burden_std ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
	actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store stegvis_m2

* Table for stepwise results
esttab stegvis_m1 stegvis_m2 ///
	using "stepwise_models.csv", replace ///
	mlabels("Model 1" "Model 2") ///
	stats(r2_w N_g N, fmt(%9.3f %9.0f %9.0f) labels(Within-R2 Cabinets Observations)) ///
	label nobaselevels plain ///
	order(months_in_office_new_cab_id burden_std cum_burden_std) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties==     2.0000" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     3.0000" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     4.0000" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_std (standardized)" "Salience of political news" ///
	"incumbency_bonus (standardized)" "Incumbency bonus" ///
	"incumbency_burden (standardized)" "Incumbency burden" ///
	"cumulated_burden (standardized)" "Cumulated incumbency burden" ///
	"Constant" "Intercept" ///
	"Observations" "N")
********************************************************************************	



************************ Various standard errors *******************************
*********************** For Table B.3 in appendix ******************************
** Classical SEs
* H2a og H2b
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	, fe 
est store classical_SEs_H2a_H2b
* H3
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	i.no_of_cab_parties#c.burden_std ///
	, re
est store classical_SEs_H3

** Driscoll Kraay SEs
* H2a og H2b
xtscc vi_gov burden_std cum_burden_std ///
	lag_vi_gov months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe
est store driscoll_SEs_H2a_H2b
* H3
xtscc vi_gov burden_std cum_burden_std cab_parties_2Xburden cab_parties_3Xburden cab_parties_4Xburden ///
	lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, re
est store driscoll_SEs_H3

** Beck and Katz SEs
* H2a og H2b
xtpcse vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties2 i.no_of_cab_parties3 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	i.new_cab_id, correlation(psar1) hetonly
est store panel_corrected_SEs_H2a_H2b
* H3
xtpcse vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	i.no_of_cab_parties#c.burden_std ///
	, correlation(psar1) hetonly
est store panel_corrected_SEs_H3

** Table
esttab classical_SEs_H2a_H2b classical_SEs_H3 driscoll_SEs_H2a_H2b driscoll_SEs_H3 panel_corrected_SEs_H2a_H2b panel_corrected_SEs_H3 ///
	using "robustness_models_part1.csv", replace ///
	stats(r2_w r2_o N_g N, fmt(%9.3f %9.3f %9.0f %9.0f) labels(Within-R2 Overall-R2 Cabinets Observations)) ///
	mlabels("Classical SEs" "" "Driscoll Kraay SEs" "" "Beck & Katz SEs" "") ///
	label nobaselevels plain  ///
	order(burden_std cum_burden_std ) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties=2" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties=3" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties=4" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_std (standardized)" "Salience of political news" ///
	"incumbency_bonus (standardized)" "Incumbency bonus" ///
	"incumbency_burden (standardized)" "Incumbency burden" ///
	"cumulated_burden (standardized)" "Cumulated incumbency burden" ///
	"Constant" "Intercept" ///
	"Observations" "N")
********************************************************************************



****************** Alternative specifications ECM and ADL **********************
*********************** For Table B.4 in appendix ******************************
** General Error Correction Model
* H2a og H2b
xtreg diff_vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    lag_unemployment diff_unemployment lag_cli diff_cli ///
    actor_occ_std ///
    lag_bonus_std diff_bonus_std lag_burden_std diff_burden_std lag_cum_burden_std ///
	, fe vce(cluster new_cab_id)
est store ecm_H2a_H2b
* H3
gen cab_parties_2Xlag_burden = no_of_cab_parties2 * lag_burden_std
gen cab_parties_3Xlag_burden = no_of_cab_parties3 * lag_burden_std
gen cab_parties_2Xdiff_burden = no_of_cab_parties2 * diff_burden_std
gen cab_parties_3Xdiff_burden = no_of_cab_parties3 * diff_burden_std
xtreg diff_vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    lag_unemployment diff_unemployment lag_cli diff_cli ///
    actor_occ_std ///
    lag_bonus_std diff_bonus_ lag_burden_std diff_burden_std lag_cum_burden_std ///
	cab_parties_2Xlag_burden cab_parties_3Xlag_burden cab_parties_2Xdiff_burden cab_parties_3Xdiff_burden ///
	, re vce(cluster new_cab_id)
est store ecm_H3

** General ADL model
* H2a og H2b
xtreg vi_gov burden_std lag_burden_std cum_burden_std ///
	lag_vi_gov months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store gen_ADL_a
* H3
xtreg vi_gov burden_std lag_burden_std cum_burden_std cab_parties_2Xburden cab_parties_3Xburden cab_parties_4Xburden  ///
	lag_vi_gov ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, re vce(cluster new_cab_id)
est store gen_ADL_b

** Table
* First ECM
esttab ecm_H2a_H2b ecm_H3 ///
	using "robustness_models_part_ecm.csv", replace ///
	stats(r2_w r2_o N_g N, fmt(%9.3f %9.3f %9.0f %9.0f) labels(Within-R2 Overall-R2 Cabinets Observations)) ///
	mlabels("General ECM" "" ) ///
	label nobaselevels plain  ///
	order(lag_burden_std diff_burden_std lag_cum_burden_std cab_parties_2Xlag_burden cab_parties_3Xlag_burden cab_parties_2Xdiff_burden cab_parties_3Xdiff_burden) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties==     2.0000" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     3.0000" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     4.0000" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_total (standardized)" "Salience of political news" ///
	"lag_bonus_std" "Incumbency bonus, t-1" ///
	"diff_bonus_std" "Incumbency bonus, change" ///
	"lag_incumbency_burden (standardized)" "Incumbency burden, t-1" ///
	"diff_incumbency_burden (standardized)" "Incumbency burden, change" ///
	"lag_cumulated_burden (standardized)" "Cumulated burden, t-1" ///
	"cab_parties_2Xburden" "Incumbency burden # 2-party cabinet" ///
	"cab_parties_3Xburden" "Incumbency burden # 3-party cabinet" ///
	"cab_parties_2Xlag_burden" "Incumbency burden, t-1 # 2-party cabinet" ///
	"cab_parties_3Xlag_burden" "Incumbency burden, t-1 # 3-party cabinet" ///
	"cab_parties_2Xdiff_burden" "Incumbency burden, change # 2-party cabinet" ///
	"cab_parties_3Xdiff_burden" "Incumbency burden, change # 3-party cabinet" ///
	"lag_Unemployment" "Unemployment, t-1" ///
	"diff_Unemployment" "Unemployment, change" ///
	"lag_Economic activity" "Economic activity, t-1" ///
	"diff_Economic activity" "Economic activity, change" ///
	"Constant" "Intercept" ///
	"Observations" "N")

* Then ADL
esttab gen_ADL_a gen_ADL_b ///
	using "robustness_models_part_adl.csv", replace ///
	stats(r2_w r2_o N_g N, fmt(%9.3f %9.3f %9.0f %9.0f) labels(Within-R2 Overall-R2 Cabinets Observations)) ///
	mlabels("General ADL" "") ///
	label nobaselevels plain  ///
	order(burden_std lag_burden_std cum_burden_std cab_parties_2Xburden cab_parties_3Xburden) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties==     2.0000" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     3.0000" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     4.0000" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_total (standardized)" "Salience of political news" ///
	"incumbency_bonus (standardized)" "Incumbency bonus" ///
	"incumbency_burden (standardized)" "Incumbency burden" ///
	"cumulated_burden (standardized)" "Cumulated incumbency burden" ///
	"lag_incumbency_bonus" "Incumbency bonus, t-1" ///
	"diff_incumbency_bonus" "Incumbency bonus, change" ///
	"lag_incumbency_burden" "Incumbency burden, t-1" ///
	"diff_incumbency_burden" "Incumbency burden, change" ///
	"lag_cumulated_burden" "Cumulated burden, t-1" ///
	"cab_parties_2Xburden" "Incumbency burden # 2-party cabinet" ///
	"cab_parties_3Xburden" "Incumbency burden # 3-party cabinet" ///
	"cab_parties_2Xlag_burden" "Incumbency burden, t-1 # 2-party cabinet" ///
	"cab_parties_3Xlag_burden" "Incumbency burden, t-1 # 3-party cabinet" ///
	"cab_parties_2Xdiff_burden" "Incumbency burden, change # 2-party cabinet" ///
	"cab_parties_3Xdiff_burden" "Incumbency burden, change # 3-party cabinet" ///
	"lag_Unemployment" "Unemployment, t-1" ///
	"diff_Unemployment" "Unemployment, change" ///
	"lag_Economic activity" "Economic activity, t-1" ///
	"diff_Economic activity" "Economic activity, change" ///
	"Constant" "Intercept" ///
	"Observations" "N")
********************************************************************************



************************ Alternative specifications ****************************
*********************** For Table B.5 in appendix ******************************
* With fixed effects but without LDV og random effects + LDV
xtreg vi_gov burden_std cum_burden_std ///
	months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, fe vce(cluster new_cab_id)
est store robustness_fe_no_ldv

* With random effects, and with LDV
xtreg vi_gov burden_std cum_burden_std ///
	lag_vi_gov months_in_office_new_cab_id ///
    no_of_cab_parties2 no_of_cab_parties3 no_of_cab_parties4 cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std bonus_std ///
	, re vce(cluster new_cab_id)
est store robustness_re_ldv

* Table
esttab robustness_fe_no_ldv robustness_re_ldv ///
	using "robustness_table_b5.csv", replace ///
	mlabels("Model 1" "Model 2") ///
	stats(r2_w N_g N, fmt(%9.3f %9.0f %9.0f) labels(Within-R2 Cabinets Observations)) ///
	label nobaselevels plain ///
	order(months_in_office_new_cab_id burden_std cum_burden_std) ///
	b(2) star(* 0.10 ** 0.05 *** 0.001) brackets nodepvars nonotes csv nonum ///
	subs("months_in_office_new_cab_id" "Tenure in months" ///
	"lag_vi_gov" "Incumbent support, t-1" ///
	"no_of_cab_parties==     2.0000" "2-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     3.0000" "3-party cabinet (ref:1-party)" ///
	"no_of_cab_parties==     4.0000" "4-party cabinet (ref:1-party)" ///
	"cab_share" "Cabinet seat share" ///
	"cab_left_right_distance" "Cabinet L-R distance" ///
	"unemployment" "Unemployment" ///
	"cli" "Economic activity" ///
	"actor_occ_std (standardized)" "Salience of political news" ///
	"incumbency_bonus (standardized)" "Incumbency bonus" ///
	"incumbency_burden (standardized)" "Incumbency burden" ///
	"cumulated_burden (standardized)" "Cumulated incumbency burden" ///
	"Constant" "Intercept" ///
	"Observations" "N")
********************************************************************************




********************************************************************************
			******	Economic news, descriptive results ********
			*************** For Table 3, manuscript ***********
********************************************************************************
* Load data
use "Bonus to Burden Economic news dataset.dta", clear

* Generate categorical variables for development in unemployment and economic activity
gen unempl_increase = diff_unemployment
recode unempl_increase (-10/-.1=-1) (-.099999/.099999=0) (.1/20=1)
tab unempl_increase

gen cli_increase = diff_cli
recode cli_increase (-10/-.1=-1) (-.099999/.099999=0) (.1/20=1)
tab cli_increase

** Results for table of descriptive stats for burden, by unemployment changes
tabstat incumbency_burden, by(unempl_increase) stat(p10 mean p90)
* Sig testing with ttest
ttest incumbency_burden == 0 if unempl_increase==-1
ttest incumbency_burden == 0 if unempl_increase==0
ttest incumbency_burden == 0 if unempl_increase==1
tab unempl_increase incumbency_burden_bin, row chi2 taub
* Sig testing with confidence intervals for proportions
ci proportions incumbency_burden_bin if unempl_increase==-1
ci proportions incumbency_burden_bin if unempl_increase==0
ci proportions incumbency_burden_bin if unempl_increase==1


** Results for table of descriptive stats for burden, by economic growth
tabstat incumbency_burden, by(cli_increase) stat(p10 mean p90)
* Sig testing with ttest
ttest incumbency_burden == 0 if cli_increase==-1
ttest incumbency_burden == 0 if cli_increase==0
ttest incumbency_burden == 0 if cli_increase==1
tab cli_increase incumbency_burden_bin, row chi2 taub
* Sig testing with confidence intervals for proportions
ci proportions incumbency_burden_bin if cli_increase==-1
ci proportions incumbency_burden_bin if cli_increase==0
ci proportions incumbency_burden_bin if cli_increase==1
********************************************************************************

	

	
********************************************************************************
			********  Checking burden by news outlets *********
			************ For Fig B1 & B2, appendix ************
********************************************************************************
* Load data
use "Bonus to Burden By news outlet dataset.dta", clear

* Line plots, country by country
line burden_aftenposten burden_dagbladet burden_vg month, title("Norway") xtitle("") legend(row(1)) scheme(s1mono) name(burden_no, replace)
line burden_ekstrabladet burden_jyllandsposten burden_politiken month, title("Denmark") xtitle("") legend(row(1)) scheme(s1mono) name(burden_dk, replace)
line burden_nrc burden_telegraaf burden_volkskrant month, title("Netherlands") xtitle("") legend(row(1)) scheme(s1mono) name(burden_nl, replace)
line burden_dailytelegraph burden_guardian burden_sun month, title("UK") xtitle("") legend(row(1)) scheme(s1mono) name(burden_uk, replace)
* Combine and export
graph combine burden_no burden_dk burden_nl burden_uk, rows(2) imargin(small) scheme(s1mono)
graph export newspapers_time.png

* Boxplots, country by country
graph box burden_aftenposten burden_dagbladet burden_vg, title("Norway") legend(row(1)) scheme(s1mono) name(burden_no, replace)
graph box burden_ekstrabladet burden_jyllandsposten burden_politiken, title("Denmark") legend(row(1)) scheme(s1mono) name(burden_dk, replace)
graph box burden_nrc burden_telegraaf burden_volkskrant, title("Netherlands") legend(row(1)) scheme(s1mono) name(burden_nl, replace)
graph box burden_dailytelegraph burden_guardian burden_sun, title("UK") legend(row(1)) scheme(s1mono) name(burden_uk, replace)
* Combine and export
graph combine burden_no burden_dk burden_nl burden_uk, rows(2) imargin(small) scheme(s1mono)
graph export newspapers.png
********************************************************************************




********************************************************************************
			****** 	Jackknife tests, leaving one country,  **********
			********  cabinet or type of news outlet out ************
			************** For Figure 4, manuscript *****************
********************************************************************************

** Dropping left-leaning papers ***********************************************
* Load data
use "Bonus to Burden WO left leaning dataset.dta", clear
	
* H2a og H2b
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	, fe vce(cluster new_cab_id)
est store wo_avis_left_papers

** Dropping right-leaning papers **********************************************
* Load data
use "Bonus to Burden WO right leaning dataset.dta", clear

* H2a og H2b
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	, fe vce(cluster new_cab_id)
est store wo_avis_right_papers

** Dropping tabloid papers incl dagbladet *************************************
* Load data
use "Bonus to Burden WO tabloids dataset.dta", clear

** H2a og H2b
xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std ///
    bonus_std burden_std cum_burden_std ///
	, fe vce(cluster new_cab_id)
est store wo_avis_tabloid_papers_db

** Re-open main dataset ********************************************************
use "Bonus to Burden Main dataset.dta", clear
xtset new_cab_id rankedmonths

** Dropping one cabinet at a time *********************************************
global vars = "7 8 9 10 11 13 14 15 17 18 19 20 21 22 23 24"
foreach x in $vars {

	* --- Main model ---
	qui: ///
	xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std  ///
    bonus_std burden_std cum_burden_std ///
	if new_cab_id!=`x', fe vce(cluster new_cab_id)
	est store wo_cab_`x'


}	
*******************************************************************************

** Dropping one country at a time *********************************************
global vars = "1 2 3 4"
foreach x in $vars {

	* --- Main model ---
	qui: ///
	xtreg vi_gov lag_vi_gov ///
	months_in_office_new_cab_id ///
    i.no_of_cab_parties cab_share cab_left_right ///
    unemployment cli ///
    actor_occ_std  ///
    bonus_std burden_std cum_burden_std ///
	if country_enc!=`x', fe vce(cluster new_cab_id)
	est store wo_country_`x'
	
}	
*******************************************************************************

** Coefplot for all jackknife analyses
coefplot ///
	(wo_*), asequation swapnames ///
	scheme(s1mono) levels(95 90)  ///
	keep(burden_std) ///
	order("Denmark" "Netherlands" "Norway" "UK" . ///
	"Nyrup Rasmussen DK" "Fogh Rasmussen DK" "Thorning-Schmidt DK" "Løkke Rasmussen DK" "Løkke Rasmussen II DK" ///
	"Kok NL" ///
	"Balkenende NL" ///
	"Rutte NL" ///
	"Bondevik NO" ///
	"Stoltenberg NO" ///
	"Bondevik II NO" ///
	"Stoltenberg II NO" ///
	"Solberg NO" ///
	"Blair/Brown UK" ///
	"Cameron UK" ///
	"Cameron/May UK" ///
	"left-leaning papers" ///
	"right-leaning papers" ///
	"tabloids") ///
	eqrename(wo_country_1 = "Denmark" ///
	wo_country_2 = "Netherlands" ///
	wo_country_3 = "Norway" ///
	wo_country_4 = "UK" ///
	wo_cab_7 = "Nyrup Rasmussen DK" ///
	wo_cab_8 = "Fogh Rasmussen DK" ///
	wo_cab_9 = "Thorning-Schmidt DK" ///
	wo_cab_10 = "Løkke Rasmussen DK" ///
	wo_cab_11 = "Løkke Rasmussen II DK" ///
	wo_cab_13 = "Kok NL" ///
	wo_cab_14 = "Balkenende NL" ///
	wo_cab_15 = "Rutte NL" ///
	wo_cab_17 = "Bondevik NO" ///
	wo_cab_18 = "Stoltenberg NO" ///
	wo_cab_19 = "Bondevik II NO" ///
	wo_cab_20 = "Stoltenberg II NO" ///
	wo_cab_21 = "Solberg NO" ///
	wo_cab_22 = "Blair/Brown UK" ///
	wo_cab_23 = "Cameron UK" ///
	wo_cab_24 = "Cameron/May UK" ///
	wo_avis_left_papers = "left-leaning papers" ///
	wo_avis_right_papers = "right-leaning papers" ///
	wo_avis_tabloid_papers_db = "tabloids") ///
	rename(burden_std="Incumbency burden") ///
	headings("Denmark" = "{it:Estimated without}"            ///
	"Nyrup Rasmussen DK" = "{it:Estimated without}"                        ///
	"left-leaning papers" = "{it:Estimated without}")    ///
	xscale(range(-0.8 0.2)) xtick(-0.8(0.2)0.2) xlabel(-0.8(0.2)0.2) xline(0, lpattern(shortdash) lcolor(black)) ///
	title("Estimated burden effect", size(small)) ///
	name (g4, replace) ///
	`display' `ci'

* Save, export
graph export jackknife.png, replace
********************************************************************************
